// RIFF WAV file format
//  __________________________
// | RIFF WAVE Chunk          |
// |   groupID  = 'RIFF'      |
// |   riffType = 'WAVE'      |
// |    __________________    |
// |   | Format Chunk     |   |
// |   |   ckID = 'fmt '  |   |
// |   |__________________|   |
// |    __________________    |
// |   | Sound Data Chunk |   |
// |   |   ckID = 'data'  |   |
// |   |__________________|   |
// |__________________________|
//
// although it is legal to have more than one data chunk, this
// program assumes there is only one.

#define RiffID (uint32)(('R' <<  0) | ('I' << 8) | ('F' << 16) | ('F' << 24))
#define WaveID (uint32)(('W' <<  0) | ('A' << 8) | ('V' << 16) | ('E' << 24))
typedef struct {
    uint32	groupID;	// should be 'RIFF'
    uint32	riffBytes;	// number of bytes in file after this header
    uint32	riffType;	// should be 'WAVE'
} RIFF_t;

#define FmtID (uint32)(('f' <<  0) | ('m' << 8) | ('t' << 16) | (' ' << 24))
typedef struct {
    uint32	chunkID;		// should be 'fmt '
    int32	chunkSize;		// not including first 8 bytes of header
    int16	FormatTag;		// 1=uncompressed
    uint16	Channels;		// number of audio channels
    uint32	Frequency;		// sample frequency
    uint32	AvgBPS;			// we'll ignore this
    uint16	BlockAlign;		// we'll ignore this
    uint16	BitsPerSample;		// should be 16
} FormatChunk_t;

#define DataID (uint32)(('d' <<  0) | ('a' << 8) | ('t' << 16) | ('a' << 24))
typedef struct {
    uint32	chunkID;	// must be 'data'
    int32	chunkSize;	// not including first 8 bytes of header
    unsigned char data[];	// everything that follows
} DataChunk_t;


